<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DiscoveryEngine;

class GoogleCloudDiscoveryengineV1ProjectConfigurableBillingStatus extends \Google\Model
{
  /**
   * @var string
   */
  public $effectiveIndexingCoreThreshold;
  /**
   * @var string
   */
  public $effectiveSearchQpmThreshold;
  /**
   * @var string
   */
  public $startTime;

  /**
   * @param string
   */
  public function setEffectiveIndexingCoreThreshold($effectiveIndexingCoreThreshold)
  {
    $this->effectiveIndexingCoreThreshold = $effectiveIndexingCoreThreshold;
  }
  /**
   * @return string
   */
  public function getEffectiveIndexingCoreThreshold()
  {
    return $this->effectiveIndexingCoreThreshold;
  }
  /**
   * @param string
   */
  public function setEffectiveSearchQpmThreshold($effectiveSearchQpmThreshold)
  {
    $this->effectiveSearchQpmThreshold = $effectiveSearchQpmThreshold;
  }
  /**
   * @return string
   */
  public function getEffectiveSearchQpmThreshold()
  {
    return $this->effectiveSearchQpmThreshold;
  }
  /**
   * @param string
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
  }
  /**
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDiscoveryengineV1ProjectConfigurableBillingStatus::class, 'Google_Service_DiscoveryEngine_GoogleCloudDiscoveryengineV1ProjectConfigurableBillingStatus');
