<?php if($seo): ?>
    <?php
        $blogDetailsRoute = Route::is('blog.details');

        $title = $general->siteName(__($pageTitle));
        $description = $seo->description;
        $image = getImage(getFilePath('seo') .'/'. $seo->image);
        $socialTitle = $seo->social_title;
        $socialDescription = $seo->social_description;
        $socialImageSize = explode('x', getFileSize('seo'));

        if($blogDetailsRoute && isset($blog->data_values))
        {
            $title = $blog->data_values->title;
            $description = strip_tags($blog->data_values->description);
            $image = getImage(getFilePath('blog') . '/' . $blog->data_values->blog_image);
            $socialTitle = $title;
            $socialDescription = $description;
        }
    ?>

    <meta name="title" content="<?php echo e(__($title)); ?>">
    <meta name="description" content="<?php echo e(__($description)); ?>">
    <meta name="keywords" content="<?php echo e(implode(',', $seo->keywords)); ?>">
    <link rel="shortcut icon" href="<?php echo e(siteFavicon()); ?>" type="image/x-icon">

    
    <link rel="apple-touch-icon" href="<?php echo e(siteLogo()); ?>">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="<?php echo e(__($title)); ?>">

    
    <meta itemprop="name" content="<?php echo e(__($title)); ?>">
    <meta itemprop="description" content="<?php echo e(__($description)); ?>">
    <meta itemprop="image" content="<?php echo e($image); ?>">


    
    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo e(__($socialTitle)); ?>">
    <meta property="og:description" content="<?php echo e(__($socialDescription)); ?>">
    <meta property="og:image" content="<?php echo e($image); ?>">
    <meta property="og:image:type" content="image/<?php echo e(pathinfo($image, PATHINFO_EXTENSION)); ?>" >
    <meta property="og:image:width" content="<?php echo e($socialImageSize[0]); ?>" >
    <meta property="og:image:height" content="<?php echo e($socialImageSize[1]); ?>" >
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">

    
    <meta name="twitter:card" content="summary_large_image">
<?php endif; ?>


<?php /**PATH C:\laragon\www\quickpost\application\resources\views/includes/seo.blade.php ENDPATH**/ ?>