<?php $__env->startSection('content'); ?>
<div class="row g-4 justify-content-center">
    <?php if(gs('free_post_status')): ?>
    <div class="col-xl-4 col-md-6">
        <div class="pricing__card bg--white">
            <img class="sparkle__sp" src="<?php echo e(asset($activeTemplateTrue . 'images/sparkle-outline.svg')); ?>" alt="image">
            <div class="pricing__topbar">
                <span class="bg--pink"><img src="<?php echo e(asset($activeTemplateTrue . 'images/sparkle.svg')); ?>" alt="image"></span>
                <h5><?php echo app('translator')->get('Free Plan'); ?></h5>
                <p><?php echo e(gs('featured_text')); ?></p>
            </div>
            <div class="pricing__include">
                <span><?php echo app('translator')->get('What\'s Included'); ?></span>
            </div>
            <div class="pricing__content">
                <ul>
                    <li>
                        <i class="fa-solid fa-circle-check text--success"></i> <?php echo e(gs('schedule_post_count')); ?> <?php echo app('translator')->get('Social Post'); ?>
                    </li>
                    <li>
                        <i class="fa-solid fa-circle-check text--success"></i> <?php echo e(gs('connected_profile')); ?> <?php echo app('translator')->get('Social Profile Connection'); ?>
                    </li>

                    <?php
                        $classes = ['warning', 'success', 'danger', 'info', 'primary'];
                    ?>

                    <?php if(count(getActivePlatformNames()) > 0): ?>
                    <li>
                        <i class="fa-solid fa-circle-check text--success"></i> <?php echo app('translator')->get('Platform Access'); ?>
                        <div class="d-flex flex-wrap gap-2 mt-2">
                            <?php $__empty_1 = true; $__currentLoopData = getActivePlatformNames(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <span class="badge badge--<?php echo e($classes[$index % count($classes)]); ?> custom--badge">
                                <?php echo e(ucfirst($data)); ?>

                            </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <span class="text-muted"><?php echo app('translator')->get('No platforms available'); ?></span>
                            <?php endif; ?>
                        </div>
                    </li>
                    <?php endif; ?>

                    <?php
                        $gContents = is_array(gs('plan_contents')) ? gs('plan_contents') : json_decode(gs('plan_contents'), true);
                    ?>

                    <?php $__empty_1 = true; $__currentLoopData = $gContents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gdata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li><i class="fa-solid fa-circle-check text--success"></i> <?php echo e(__($gdata)); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                    <?php endif; ?>

                </ul>
                <a href="<?php echo e(auth()->user()->free_plan_used ? 'javascript:void(0)' : route('user.free.plan.subscription')); ?>" class="btn btn-outline--base w-100"><?php echo e(auth()->user()->free_plan_used ? __('SUBSCRIBED') : __('SUBSCRIBE NOW')); ?></a>
            </div>
        </div>
    </div>
    <?php endif; ?>



    <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index =>$plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <?php
            $colors = ['bg--success', 'bg--danger', 'bg--warning', 'bg--pink', 'bg--primary'];

            $dotClass = $colors[$index % count($colors)];
        ?>

    <div class="col-xl-4 col-md-6">
        <div class="pricing__card bg--white">
            <?php if($plan->feature_status): ?>
            <span class="pricing__label"><?php echo app('translator')->get('Popular'); ?></span>
            <?php endif; ?>
            <img class="sparkle__sp" src="<?php echo e(asset($activeTemplateTrue . 'images/sparkle-outline.svg')); ?>" alt="image">
            <div class="pricing__topbar">
                <span class="<?php echo e($index  ? $dotClass : 'bg--info'); ?>"><img src="<?php echo e(asset($activeTemplateTrue . 'images/sparkle.svg')); ?>" alt="image"></span>
                <h5><?php echo e(__($plan->name)); ?></h5>
                <p><?php echo e(__($plan->short_description)); ?></p>
                <h3><?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($plan->price, 2)); ?><span>/<?php echo e($plan->type == 1 ? trans('mon') : trans('yer')); ?></span></h3>
            </div>
            <div class="pricing__include">
                <span><?php echo app('translator')->get('What\'s Included'); ?></span>
            </div>
            <div class="pricing__content">
                <ul>
                    <li>
                        <i class="fa-solid fa-circle-check text--success"></i> <?php echo e($plan->schedule_post); ?> <?php echo app('translator')->get('Social Post'); ?>
                    </li>
                    <li>
                        <i class="fa-solid fa-circle-check text--success"></i> <?php echo e($plan->connected_profile); ?> <?php echo app('translator')->get('Social Profile Connection'); ?>
                    </li>

                        <?php
                            $platforms = getPlatformNames($plan->platform_access);
                            $classes = ['warning', 'success', 'danger', 'info', 'primary'];
                        ?>

                    <?php if(count($platforms) > 0): ?>
                    <li>
                        <i class="fa-solid fa-circle-check text--success"></i> <?php echo app('translator')->get('Platform Access'); ?>
                        <div class="d-flex flex-wrap gap-2 mt-2">
                            <?php $__empty_2 = true; $__currentLoopData = $platforms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                            <span class="badge badge--<?php echo e($classes[$index % count($classes)]); ?> custom--badge">
                                <?php echo e(ucfirst($data)); ?>

                            </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                            <span class="text-muted"><?php echo app('translator')->get('No platforms available'); ?></span>
                            <?php endif; ?>
                        </div>
                    </li>
                    <?php endif; ?>

                    <?php if($plan->schedule_status): ?>
                        <li><i class="fa-solid fa-circle-check text--success"></i> <?php echo app('translator')->get('Schedule posting available'); ?></li>
                    <?php else: ?>
                        <li><i class="fa-solid fa-circle-check text--danger"></i> <?php echo app('translator')->get('Schedule posting not available'); ?></li>
                    <?php endif; ?>

                    <?php if($plan->ai_assistant_status): ?>
                        <li><i class="fa-solid fa-circle-check text--success"></i> <?php echo app('translator')->get('Generate '); ?> <?php echo e($plan->generated_content_count); ?> <?php echo app('translator')->get('content via AI'); ?></li>
                    <?php else: ?>
                        <li><i class="fa-solid fa-circle-xmark text--danger"></i> <?php echo app('translator')->get('AI Assistant not available'); ?></li>
                    <?php endif; ?>

                    <?php
                        $contents = is_array($plan->contents) ? $plan->contents : json_decode($plan->contents, true);
                    ?>

                    <?php $__empty_2 = true; $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                        <li><i class="fa-solid fa-circle-check text--success"></i> <?php echo e(__($data)); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>

                    <?php endif; ?>
                </ul>
                <?php if(auth()->user()->plan_id == $plan->id): ?>
                <span class="btn btn-outline--base w-100"><?php echo app('translator')->get('SUBSCRIBED'); ?></span>
                <?php else: ?>
                <a href="<?php echo e(route('user.plan.payment', $plan->id)); ?>" class="btn btn-outline--base w-100"><?php echo app('translator')->get('SUBSCRIBE NOW'); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

    <?php endif; ?>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<form>
    <div class="search__box">
        <input type="search" class="form-control" name="search" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search by plan, price'); ?>">
        <button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
    </div>
</form>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\quickpost\application\resources\views/presets/default/user/plans.blade.php ENDPATH**/ ?>