<?php
    $user = auth()->user();
    $userNotifications = App\Models\UserNotification::where('is_read', Status::NO)->where('user_id', $user->id)->orderBy('id', 'desc')->take(10)->get();

    $userNotificationCount = $userNotifications->count();
?>


<div class="dashboard__header">
    <div class="current__balance">
        <h4><?php echo app('translator')->get('Image Credit'); ?> <span><?php echo e(showAmount(auth()->user()->image_credit,2)); ?></span></h4>
    </div>
    <div class="dashboard__header__widgets">
        <a href="<?php echo e(route('home')); ?>" class="ds__home"><i class="fa-solid fa-house"></i></a>
        <div class="dropdown">
            <button type="button" data-bs-toggle="dropdown" aria-expanded="false">
                <span class="notification__btn">
                    <i class="las la-bell"></i>
                    <span class="notification__count">
                        <span><?php echo e($userNotificationCount > 0 ? $userNotificationCount : '0'); ?></span>
                    </span>
                </span>
            </button>
            <div class="dropdown-menu">
                <div class="notification__wrap">
                    <div class="notification__header">
                        <h4><?php echo app('translator')->get('Notification'); ?></h4>
                        <span class="badge badge--base"><?php echo e($userNotificationCount); ?> <?php echo app('translator')->get('Unread'); ?></span>
                    </div>
                    <div class="notification__body">
                        <?php $__empty_1 = true; $__currentLoopData = $userNotifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <a href="<?php echo e(route('user.notification.read', $notification->id)); ?>">
                            <p><?php echo e(__($notification->title)); ?></p>
                            <span><?php echo e($notification->created_at->diffForHumans()); ?></span>
                        </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <a href="javascript:void(0)">
                                <p><?php echo app('translator')->get('No unread notification found'); ?></p>
                            </a>
                        <?php endif; ?>
                    </div>
                    <?php if($userNotificationCount > 0): ?>
                    <div class="notification__footer">
                        <a href="<?php echo e(route('user.notifications')); ?>" class="btn btn--base w-100"><?php echo app('translator')->get('View All'); ?></a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="dropdown">
            <button class="dropdown-toggle d-flex align-items-center gap-2" type="button"
                data-bs-toggle="dropdown" aria-expanded="false">
                <span class="profile__dropdown">
                    <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . auth()->user()->image, getFileSize('userProfile'))); ?>" alt="<?php echo app('translator')->get('Image'); ?>">
                    <span><?php echo e(auth()->user()->fullname); ?></span>
                </span>
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="<?php echo e(route('user.profile.setting')); ?>"><?php echo app('translator')->get('Profile Setting'); ?></a></li>
                <li><a class="dropdown-item" href="<?php echo e(route('user.change.password')); ?>"><?php echo app('translator')->get('Change Password'); ?></a></li>
                <li><a class="dropdown-item" href="<?php echo e(route('user.twofactor')); ?>"><?php echo app('translator')->get('2FA Setting'); ?></a></li>
                <li><a class="dropdown-item" href="<?php echo e(route('user.logout')); ?>"><?php echo app('translator')->get('Logout'); ?></a></li>
            </ul>
        </div>
        <span class="sidebar__open"><i class="fa-solid fa-bars"></i></span>
    </div>
</div>
<?php /**PATH C:\laragon\www\quickpost\application\resources\views/presets/default/components/dashboard_header.blade.php ENDPATH**/ ?>