<!doctype html>
<html lang="<?php echo e(config('app.locale')); ?>" itemscope itemtype="http://schema.org/WebPage">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e($general->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('includes.seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <link rel="shortcut icon" href="<?php echo e(siteFavicon()); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/line-awesome.min.css')); ?>">

    <?php echo $__env->yieldPushContent('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/swiper-bundle.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/main.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/color.php')); ?>?color=<?php echo e($general->base_color); ?>&secondColor=<?php echo e($general->secondary_color); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/custom.css')); ?>">
    <?php echo $__env->yieldPushContent('style'); ?>
</head>
<body>

    <?php if ($__env->exists('Template::components.preloader')) echo $__env->make('Template::components.preloader', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <main>
        <div class="auth__area">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>



    <script src="<?php echo e(asset('assets/common/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/common/js/bootstrap.bundle.min.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('script-lib'); ?>
    <script src="<?php echo e(asset($activeTemplateTrue.'js/scrollreveal.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'js/swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue.'js/main.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('script'); ?>

    <?php echo $__env->make('includes.plugins', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php echo $__env->make('includes.notify', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>



</body>
</html>
<?php /**PATH C:\laragon\www\quickpost\application\resources\views/presets/default/layouts/auth.blade.php ENDPATH**/ ?>